#include <utils/PugsUtils.hpp>

#include <language/PugsParser.hpp>
#include <mesh/DiamondDualConnectivityManager.hpp>
#include <mesh/DiamondDualMeshManager.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/SynchronizerManager.hpp>

int
main(int argc, char* argv[])
{
  std::string filename = initialize(argc, argv);

  SynchronizerManager::create();
  MeshDataManager::create();
  DiamondDualConnectivityManager::create();
  DiamondDualMeshManager::create();

  parser(filename);

  DiamondDualMeshManager::destroy();
  DiamondDualConnectivityManager::destroy();
  MeshDataManager::destroy();
  SynchronizerManager::destroy();
  finalize();
  return 0;
}
