#ifndef ACOUSTIC_SOLVER_ALGORITHM_HPP
#define ACOUSTIC_SOLVER_ALGORITHM_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <scheme/AcousticSolverType.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

template <size_t Dimension>
struct AcousticSolverAlgorithm
{
  AcousticSolverAlgorithm(const AcousticSolverType& solver_type,
                          std::shared_ptr<const IMesh> i_mesh,
                          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
                          const FunctionSymbolId& rho_id,
                          const FunctionSymbolId& u_id,
                          const FunctionSymbolId& p_id);
};

#endif   // ACOUSTIC_SOLVER_ALGORITHM_HPP
