#include <algebra/PETScWrapper.hpp>

#include <utils/pugs_config.hpp>

#ifdef PUGS_HAS_PETSC
#include <petsc.h>
#endif   // PUGS_HAS_PETSC

namespace PETScWrapper
{
void
initialize([[maybe_unused]] int& argc, [[maybe_unused]] char* argv[])
{
#ifdef PUGS_HAS_PETSC
  PetscOptionsSetValue(NULL, "-no_signal_handler", "true");
  PetscInitialize(&argc, &argv, 0, 0);
#endif   // PUGS_HAS_PETSC
}

void
finalize()
{
#ifdef PUGS_HAS_PETSC
  PetscFinalize();
#endif   // PUGS_HAS_PETSC
}
}   // namespace PETScWrapper
