#ifndef AST_NODE_DATA_TYPE_TRAITS_H
#define AST_NODE_DATA_TYPE_TRAITS_H

#include <algebra/TinyVector.hpp>
#include <language/ast/ASTNodeDataType.hpp>
#include <language/utils/FunctionSymbolId.hpp>

template <typename T>
inline ASTNodeDataType ast_node_data_type_from = ASTNodeDataType::undefined_t;

template <>
inline ASTNodeDataType ast_node_data_type_from<void> = ASTNodeDataType::void_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<bool> = ASTNodeDataType::bool_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<int64_t> = ASTNodeDataType::int_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<uint64_t> = ASTNodeDataType::unsigned_int_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<double> = ASTNodeDataType::double_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::string> = ASTNodeDataType::string_t;
template <>
inline ASTNodeDataType ast_node_data_type_from<FunctionSymbolId> = ASTNodeDataType::function_t;
template <size_t N>
inline ASTNodeDataType ast_node_data_type_from<TinyVector<N>> = {ASTNodeDataType::vector_t, N};

#endif   // AST_NODE_DATA_TYPE_TRAITS_H
