#ifndef EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP
#define EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP

#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>
#include <utils/Exceptions.hpp>

#include <sstream>
#include <string>

template <typename T>
PUGS_INLINE std::string
operand_type_name(const T& t)
{
  if constexpr (is_shared_ptr_v<T>) {
    Assert(t.use_count() > 0);
    return operand_type_name(*t);
  } else if constexpr (std::is_base_of_v<IDiscreteFunction, std::decay_t<T>>) {
    return "Vh(" + name(t.descriptor().type()) + ':' + dataTypeName(t.dataType()) + ')';
  } else {
    return dataTypeName(ast_node_data_type_from<T>);
  }
}

PUGS_INLINE
bool
isSameDiscretization(const IDiscreteFunction& f, const IDiscreteFunction& g)
{
  if ((f.dataType() == g.dataType()) and (f.descriptor().type() == g.descriptor().type())) {
    switch (f.dataType()) {
    case ASTNodeDataType::double_t: {
      return true;
    }
    case ASTNodeDataType::vector_t: {
      return f.dataType().dimension() == g.dataType().dimension();
    }
    case ASTNodeDataType::matrix_t: {
      return (f.dataType().numberOfRows() == g.dataType().numberOfRows()) and
             (f.dataType().numberOfColumns() == g.dataType().numberOfColumns());
    }
    default: {
      throw UnexpectedError("invalid data type " + operand_type_name(f));
    }
    }
  } else {
    return false;
  }
}

PUGS_INLINE
bool
isSameDiscretization(const std::shared_ptr<const IDiscreteFunction>& f,
                     const std::shared_ptr<const IDiscreteFunction>& g)
{
  return isSameDiscretization(*f, *g);
}

#endif   // EMBEDDED_I_DISCRETE_FUNCTION_UTILS_HPP
