#include <language/modules/UnaryOperatorRegisterForVh.hpp>

#include <language/modules/SchemeModule.hpp>
#include <language/utils/DataHandler.hpp>
#include <language/utils/DataVariant.hpp>
#include <language/utils/EmbeddedIDiscreteFunctionOperators.hpp>
#include <language/utils/OperatorRepository.hpp>
#include <language/utils/UnaryOperatorProcessorBuilder.hpp>
#include <scheme/IDiscreteFunction.hpp>

void
UnaryOperatorRegisterForVh::_register_unary_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  repository.addUnaryOperator<language::unary_minus>(
    std::make_shared<UnaryOperatorProcessorBuilder<language::unary_minus, std::shared_ptr<const IDiscreteFunction>,
                                                   std::shared_ptr<const IDiscreteFunction>>>());
}

UnaryOperatorRegisterForVh::UnaryOperatorRegisterForVh()
{
  this->_register_unary_minus();
}
