#include <language/modules/CoreModule.hpp>

#include <language/modules/CoreModule.hpp>
#include <language/modules/ModuleRepository.hpp>
#include <language/utils/ASTExecutionInfo.hpp>
#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/AffectationRegisterForB.hpp>
#include <language/utils/AffectationRegisterForN.hpp>
#include <language/utils/AffectationRegisterForR.hpp>
#include <language/utils/AffectationRegisterForRn.hpp>
#include <language/utils/AffectationRegisterForRnxn.hpp>
#include <language/utils/AffectationRegisterForString.hpp>
#include <language/utils/AffectationRegisterForZ.hpp>
#include <language/utils/BinaryOperatorRegisterForB.hpp>
#include <language/utils/BinaryOperatorRegisterForN.hpp>
#include <language/utils/BinaryOperatorRegisterForR.hpp>
#include <language/utils/BinaryOperatorRegisterForRn.hpp>
#include <language/utils/BinaryOperatorRegisterForRnxn.hpp>
#include <language/utils/BinaryOperatorRegisterForString.hpp>
#include <language/utils/BinaryOperatorRegisterForZ.hpp>
#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/IncDecOperatorRegisterForN.hpp>
#include <language/utils/IncDecOperatorRegisterForR.hpp>
#include <language/utils/IncDecOperatorRegisterForZ.hpp>
#include <language/utils/UnaryOperatorRegisterForB.hpp>
#include <language/utils/UnaryOperatorRegisterForN.hpp>
#include <language/utils/UnaryOperatorRegisterForR.hpp>
#include <language/utils/UnaryOperatorRegisterForRn.hpp>
#include <language/utils/UnaryOperatorRegisterForRnxn.hpp>
#include <language/utils/UnaryOperatorRegisterForZ.hpp>
#include <utils/Messenger.hpp>
#include <utils/PugsUtils.hpp>
#include <utils/RandomEngine.hpp>

#include <random>

CoreModule::CoreModule() : BuiltinModule(true)
{
  this->_addBuiltinFunction("getPugsVersion", std::make_shared<BuiltinFunctionEmbedder<std::string(void)>>(

                                                []() -> std::string { return pugsVersion(); }

                                                ));

  this->_addBuiltinFunction("getPugsBuildInfo", std::make_shared<BuiltinFunctionEmbedder<std::string(void)>>(

                                                  []() -> std::string { return pugsBuildInfo(); }

                                                  ));

  this->_addBuiltinFunction("getAvailableModules", std::make_shared<BuiltinFunctionEmbedder<std::string()>>(

                                                     []() -> std::string {
                                                       const ModuleRepository& repository =
                                                         ASTExecutionInfo::current().moduleRepository();

                                                       return repository.getAvailableModules();
                                                     }

                                                     ));

  this->_addBuiltinFunction("getModuleInfo", std::make_shared<BuiltinFunctionEmbedder<std::string(const std::string&)>>(

                                               [](const std::string& module_name) -> std::string {
                                                 const ModuleRepository& repository =
                                                   ASTExecutionInfo::current().moduleRepository();

                                                 return repository.getModuleInfo(module_name);
                                               }

                                               ));

  this->_addBuiltinFunction("setRandomSeed", std::make_shared<BuiltinFunctionEmbedder<void(const int64_t&)>>(

                                               [](const int64_t& random_seed) -> void {
                                                 RandomEngine::instance().setRandomSeed(random_seed);
                                               }

                                               ));

  this->_addBuiltinFunction("resetRandomSeed", std::make_shared<BuiltinFunctionEmbedder<void(void)>>(

                                                 []() { RandomEngine::instance().resetRandomSeed(); }

                                                 ));
}

void
CoreModule::registerOperators() const
{
  AffectationRegisterForB{};
  AffectationRegisterForN{};
  AffectationRegisterForZ{};
  AffectationRegisterForR{};
  AffectationRegisterForRn<1>{};
  AffectationRegisterForRn<2>{};
  AffectationRegisterForRn<3>{};
  AffectationRegisterForRnxn<1>{};
  AffectationRegisterForRnxn<2>{};
  AffectationRegisterForRnxn<3>{};
  AffectationRegisterForString{};

  BinaryOperatorRegisterForB{};
  BinaryOperatorRegisterForN{};
  BinaryOperatorRegisterForZ{};
  BinaryOperatorRegisterForR{};
  BinaryOperatorRegisterForRn<1>{};
  BinaryOperatorRegisterForRn<2>{};
  BinaryOperatorRegisterForRn<3>{};
  BinaryOperatorRegisterForRnxn<1>{};
  BinaryOperatorRegisterForRnxn<2>{};
  BinaryOperatorRegisterForRnxn<3>{};
  BinaryOperatorRegisterForString{};

  IncDecOperatorRegisterForN{};
  IncDecOperatorRegisterForR{};
  IncDecOperatorRegisterForZ{};

  UnaryOperatorRegisterForB{};
  UnaryOperatorRegisterForN{};
  UnaryOperatorRegisterForZ{};
  UnaryOperatorRegisterForR{};
  UnaryOperatorRegisterForRn<1>{};
  UnaryOperatorRegisterForRn<2>{};
  UnaryOperatorRegisterForRn<3>{};
  UnaryOperatorRegisterForRnxn<1>{};
  UnaryOperatorRegisterForRnxn<2>{};
  UnaryOperatorRegisterForRnxn<3>{};
}
