#ifndef EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP
#define EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP

#include <algebra/TinyMatrix.hpp>
#include <algebra/TinyVector.hpp>

#include <memory>

class IDiscreteFunction;

std::shared_ptr<const IDiscreteFunction> operator+(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator-(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator/(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const double&, const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<1>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<2>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const TinyMatrix<3>&,
                                                   const std::shared_ptr<const IDiscreteFunction>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<1>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<2>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyVector<3>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<1>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<2>&);

std::shared_ptr<const IDiscreteFunction> operator*(const std::shared_ptr<const IDiscreteFunction>&,
                                                   const TinyMatrix<3>&);

#endif   // EMBEDDED_I_DISCRETE_FUNCTION_OPERATORS_HPP
