#define CATCH_CONFIG_RUNNER
#include <catch2/catch.hpp>

#include <Kokkos_Core.hpp>

int
main(int argc, char* argv[])
{
  Kokkos::initialize({4, -1, -1, true});

  Catch::Session session;
  int result = session.applyCommandLine(argc, argv);

  if (result == 0) {
    // Disable outputs from tested classes to the standard output
    std::cout.setstate(std::ios::badbit);
    result = session.run();
  }

  Kokkos::finalize();

  return result;
}
