#include <catch2/catch.hpp>

#include <test_BinaryExpressionProcessor_utils.hpp>

// clazy:excludeall=non-pod-global-static

TEST_CASE("BinaryExpressionProcessor logic", "[language]")
{
  SECTION("and")
  {
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true and true;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false and true;)", "b", false);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true and false;)", "b", false);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false and false;)", "b", false);

    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = (2<3) and ((3.2-1) != 2);)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = (1>4) and true;)", "b", false);
  }

  SECTION("or")
  {
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true or true;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false or true;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true or false;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false or false;)", "b", false);

    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = (2<3) and ((3.2-1) != 2);)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = (1>4) or true;)", "b", true);
  }

  SECTION("xor")
  {
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true xor true;)", "b", false);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false xor true;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = true xor false;)", "b", true);
    CHECK_BINARY_EXPRESSION_RESULT(R"(let b:B, b = false xor false;)", "b", false);
  }

  SECTION("errors")
  {
    SECTION("bad implicit conversion")
    {
      SECTION("and")
      {
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=1; n and true;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=2; false and n;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1 and true;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false and 2;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1.1 and true;)", "invalid implicit conversion: R -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false and 2e-2;)", "invalid implicit conversion: R -> B");
      }

      SECTION("or")
      {
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=1; n or true;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=2; false or n;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1 or true;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false or 2;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1.1 or true;)", "invalid implicit conversion: R -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false or 2e-2;)", "invalid implicit conversion: R -> B");
      }

      SECTION("xor")
      {
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=1; n xor true;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(let n:N, n=2; false xor n;)", "invalid implicit conversion: N -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1 xor true;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false xor 2;)", "invalid implicit conversion: Z -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(1.1 xor true;)", "invalid implicit conversion: R -> B");
        CHECK_BINARY_EXPRESSION_THROWS_WITH(R"(false xor 2e-2;)", "invalid implicit conversion: R -> B");
      }
    }
  }
}
