#include <catch2/catch.hpp>

#include <test_BinaryExpressionProcessor_utils.hpp>

// clazy:excludeall=non-pod-global-static

TEST_CASE("BinaryExpressionProcessor arithmetic", "[language]")
{
  SECTION("+")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = true + true;)", "z", 2l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; n = true + 1;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; n = true + 1;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; n = false + 1;)", "n", 1ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = true + 3;)", "z", 4l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = false + 3;)", "z", 3l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = false + 3.6;)", "r", 3.6);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let s:R, s = -3.3; let r:R, r = true + s;)", "r", -2.3);
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; n = n + true;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let m:N, m = 2; n = n + m;)", "n", 6ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let z:Z, z = -1; n = n + z;)", "n", 3ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; let x:R, x = n + 2.3;)", "x", 3.3);
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = -1 + true;)", "z", 0l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let z:Z, z = -3 + n;)", "z", 1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; let z:Z, z = -3 + n;)", "z", -1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = 1 + 2;)", "z", 3l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let x:R, x = 3 + 2.5;)", "x", 5.5);
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 + true;)", "r", (-1.2 + true));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; let r:R, r = -1.2 + n;)", "r", (-1.2 + uint64_t{2}));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 + 1;)", "r", (-1.2 + 1));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 + 2.3;)", "r", (-1.2 + 2.3));
    }
  }

  SECTION("-")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = true - false;)", "n", 1ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 1; n = true - n;)", "n", 0ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = false - 1;)", "z", -1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = true - 1.2;)", "r", (true - 1.2));
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; n = n - true;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let m:N, m = 2; n = n - m;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 5; n = n - 4;)", "n", 1ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; let x:R, x = n - 2.3;)", "x", double{3ul - 2.3});
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = -1 - true;)", "z", -2l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let z:Z, z = 3 - n;)", "z", -1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = 7 - 2;)", "z", 5l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let x:R, x = 4 - 2.5;)", "x", 1.5);
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 - true;)", "r", (-1.2 - true));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; let r:R, r = -1.2 - n;)", "r", (-1.2 - uint64_t{2}));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 - 1;)", "r", (-1.2 - 1));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 - 2.3;)", "r", (-1.2 - 2.3));
    }
  }

  SECTION("*")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = true * false;)", "n", 0ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; n = true * n;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = false * 1;)", "z", 0l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = true * 1.2;)", "r", (true * 1.2));
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; n = n * true;)", "n", 3ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let m:N, m = 2; n = n * m;)", "n", 8ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 5; n = n * 4;)", "n", 20ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; let x:R, x = n * 2.3;)", "x", double{3ul * 2.3});
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = -1 * true;)", "z", -1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let z:Z, z = 3 * n;)", "z", 12l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = 7 * 2;)", "z", 14l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let x:R, x = 4 * 2.4;)", "x", double{4l * 2.4});
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 * true;)", "r", (-1.2 * true));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; let r:R, r = -1.2 * n;)", "r", (-1.2 * uint64_t{2}));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 * 11;)", "r", (-1.2 * 11));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 * 2.3;)", "r", (-1.2 * 2.3));
    }
  }

  SECTION("/")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = false / true;)", "n", 0ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; n = true / n;)", "n", 0ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = false / 1;)", "z", 0l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = true / 1.2;)", "r", (true / 1.2));
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; n = n / true;)", "n", 3ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let m:N, m = 2; n = n / m;)", "n", 2ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 5; n = n / 4;)", "n", 1ul);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 3; let x:R, x = n / 2.3;)", "x", double{3ul / 2.3});
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = -1 / true;)", "z", -1l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 4; let z:Z, z = 3 / n;)", "z", 0l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let z:Z, z = 7 / 2;)", "z", 3l);
      CHECK_BINARY_EXPRESSION_RESULT(R"(let x:R, x = 4 / 2.4;)", "x", double{4l / 2.4});
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 / true;)", "r", (-1.2 / true));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let n:N, n = 2; let r:R, r = -1.2 / n;)", "r", (-1.2 / uint64_t{2}));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 / 11;)", "r", (-1.2 / 11));
      CHECK_BINARY_EXPRESSION_RESULT(R"(let r:R, r = -1.2 / 2.3;)", "r", (-1.2 / 2.3));
    }
  }
}
