#include <catch2/catch.hpp>

#include <language/ast/ASTBuilder.hpp>
#include <language/ast/ASTNodeDataTypeBuilder.hpp>
#include <language/ast/ASTNodeDataTypeChecker.hpp>
#include <language/ast/ASTSymbolTableBuilder.hpp>

#include <pegtl/string_input.hpp>

// clazy:excludeall=non-pod-global-static

TEST_CASE("ASTNodeDataTypeChecker", "[language]")
{
  SECTION("everything ok: nothrow")
  {
    std::string_view data = R"(
for(let i:Z, i=0; i<10; ++i) {
 cout << "i=" << i;
 cout<< "\n";
}
)";

    string_input input{data, "test.pgs"};
    auto ast = ASTBuilder::build(input);

    ASTSymbolTableBuilder{*ast};
    ASTNodeDataTypeBuilder{*ast};

    REQUIRE_NOTHROW(ASTNodeDataTypeChecker{*ast});
  }

  SECTION("everything uninitialized node type")
  {
    std::string_view data = R"(
for(let i:Z, i=0; i<10; ++i) {
 cout << "i=" << i;
 cout<< "\n";
}
)";

    string_input input{data, "test.pgs"};
    auto ast = ASTBuilder::build(input);

    ASTSymbolTableBuilder{*ast};
    ASTNodeDataTypeBuilder{*ast};

    ast->children[0]->m_data_type = ASTNodeDataType::undefined_t;

    REQUIRE_THROWS_AS(ASTNodeDataTypeChecker{*ast}, parse_error);
  }
}
