#define CATCH_CONFIG_RUNNER
#include <catch2/catch.hpp>

#include <Kokkos_Core.hpp>

#include <utils/Messenger.hpp>

#include <cstdlib>

int
main(int argc, char* argv[])
{
  parallel::Messenger::create(argc, argv);
  Kokkos::initialize({4, -1, -1, true});

  // Disable outputs from tested classes to the standard output
  std::cout.setstate(std::ios::badbit);

  if (parallel::rank() != 0) {
    setenv("GCOV_PREFIX", "/dev/null", 1);
  }
  Catch::Session session;
  int result = session.applyCommandLine(argc, argv);

  if (result == 0) {
    // Disable outputs from tested classes to the standard output
    std::cout.setstate(std::ios::badbit);
    result = session.run();
  }

  Kokkos::finalize();
  parallel::Messenger::destroy();

  return result;
}
