#include <catch2/catch.hpp>

#include <utils/PugsAssert.hpp>

#include <algebra/Vector.hpp>

// Instantiate to ensure full coverage is performed
template class Vector<int>;

// clazy:excludeall=non-pod-global-static

TEST_CASE("Vector", "[algebra]")
{
  SECTION("size")
  {
    Vector<int> x{5};
    REQUIRE(x.size() == 5);
  }

  SECTION("write access")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    REQUIRE(x[0] == 0);
    REQUIRE(x[1] == 1);
    REQUIRE(x[2] == 2);
    REQUIRE(x[3] == 3);
    REQUIRE(x[4] == 4);
  }

  SECTION("fill")
  {
    Vector<int> x{5};
    x = 2;

    REQUIRE(x[0] == 2);
    REQUIRE(x[1] == 2);
    REQUIRE(x[2] == 2);
    REQUIRE(x[3] == 2);
    REQUIRE(x[4] == 2);
  }

  SECTION("copy constructor (shallow)")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    const Vector<int> y = x;
    REQUIRE(y[0] == 0);
    REQUIRE(y[1] == 1);
    REQUIRE(y[2] == 2);
    REQUIRE(y[3] == 3);
    REQUIRE(y[4] == 4);
  }

  SECTION("copy (deep)")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    const Vector<int> y = copy(x);

    x[0] = 14;
    x[1] = 13;
    x[2] = 12;
    x[3] = 11;
    x[4] = 10;

    REQUIRE(y[0] == 0);
    REQUIRE(y[1] == 1);
    REQUIRE(y[2] == 2);
    REQUIRE(y[3] == 3);
    REQUIRE(y[4] == 4);

    REQUIRE(x[0] == 14);
    REQUIRE(x[1] == 13);
    REQUIRE(x[2] == 12);
    REQUIRE(x[3] == 11);
    REQUIRE(x[4] == 10);
  }

  SECTION("self scalar multiplication")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    x *= 2;

    REQUIRE(x[0] == 0);
    REQUIRE(x[1] == 2);
    REQUIRE(x[2] == 4);
    REQUIRE(x[3] == 6);
    REQUIRE(x[4] == 8);
  }

  SECTION("left scalar multiplication")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    const Vector<int> y = 2 * x;

    REQUIRE(y[0] == 0);
    REQUIRE(y[1] == 2);
    REQUIRE(y[2] == 4);
    REQUIRE(y[3] == 6);
    REQUIRE(y[4] == 8);
  }

  SECTION("dot product")
  {
    Vector<int> x{5};
    x[0] = 0;
    x[1] = 1;
    x[2] = 2;
    x[3] = 3;
    x[4] = 4;

    Vector<int> y{5};
    y[0] = 7;
    y[1] = 3;
    y[2] = 4;
    y[3] = 2;
    y[4] = 8;

    const int dot = (x, y);
    REQUIRE(dot == 49);
  }

  SECTION("self scalar division")
  {
    Vector<int> x{5};
    x[0] = 2;
    x[1] = 3;
    x[2] = 5;
    x[3] = 7;
    x[4] = 8;

    x /= 2;

    REQUIRE(x[0] == 1);
    REQUIRE(x[1] == 1);
    REQUIRE(x[2] == 2);
    REQUIRE(x[3] == 3);
    REQUIRE(x[4] == 4);
  }

  SECTION("self minus")
  {
    Vector<int> x{5};
    x[0] = 2;
    x[1] = 3;
    x[2] = 5;
    x[3] = 7;
    x[4] = 8;

    Vector<int> y{5};
    y[0] = 3;
    y[1] = 8;
    y[2] = 6;
    y[3] = 2;
    y[4] = 4;

    x -= y;

    REQUIRE(x[0] == -1);
    REQUIRE(x[1] == -5);
    REQUIRE(x[2] == -1);
    REQUIRE(x[3] == 5);
    REQUIRE(x[4] == 4);
  }

  SECTION("self sum")
  {
    Vector<int> x{5};
    x[0] = 2;
    x[1] = 3;
    x[2] = 5;
    x[3] = 7;
    x[4] = 8;

    Vector<int> y{5};
    y[0] = 3;
    y[1] = 8;
    y[2] = 6;
    y[3] = 2;
    y[4] = 4;

    x += y;

    REQUIRE(x[0] == 5);
    REQUIRE(x[1] == 11);
    REQUIRE(x[2] == 11);
    REQUIRE(x[3] == 9);
    REQUIRE(x[4] == 12);
  }

  SECTION("sum")
  {
    Vector<int> x{5};
    x[0] = 2;
    x[1] = 3;
    x[2] = 5;
    x[3] = 7;
    x[4] = 8;

    Vector<int> y{5};
    y[0] = 3;
    y[1] = 8;
    y[2] = 6;
    y[3] = 2;
    y[4] = 4;

    Vector z = x + y;

    REQUIRE(z[0] == 5);
    REQUIRE(z[1] == 11);
    REQUIRE(z[2] == 11);
    REQUIRE(z[3] == 9);
    REQUIRE(z[4] == 12);
  }

  SECTION("difference")
  {
    Vector<int> x{5};
    x[0] = 2;
    x[1] = 3;
    x[2] = 5;
    x[3] = 7;
    x[4] = 8;

    Vector<int> y{5};
    y[0] = 3;
    y[1] = 8;
    y[2] = 6;
    y[3] = 2;
    y[4] = 4;

    Vector z = x - y;

    REQUIRE(z[0] == -1);
    REQUIRE(z[1] == -5);
    REQUIRE(z[2] == -1);
    REQUIRE(z[3] == 5);
    REQUIRE(z[4] == 4);
  }
}
