#include <catch2/catch.hpp>

#include <language/utils/DataVariant.hpp>

#include <sstream>

// clazy:excludeall=non-pod-global-static

TEST_CASE("DataVariant", "[language]")
{
  SECTION("AggregateDataVariant")
  {
    AggregateDataVariant aggregate{std::vector<DataVariant>{double{1.3}, int64_t{-3}, std::vector<double>{1, 2.7}}};

    SECTION("size")
    {
      REQUIRE(aggregate.size() == 3);
    }

    SECTION("output")
    {
      std::stringstream aggregate_output;
      aggregate_output << aggregate;

      std::stringstream expected_output;
      expected_output << '(' << double{1.3} << ", " << int64_t{-3} << ", (" << 1 << ", " << 2.7 << "))";
      REQUIRE(aggregate_output.str() == expected_output.str());
    }

    SECTION("values")
    {
      REQUIRE(std::get<double>(aggregate[0]) == double{1.3});
      REQUIRE(std::get<int64_t>(aggregate[1]) == int64_t{-3});
      REQUIRE(std::get<std::vector<double>>(aggregate[2]) == std::vector<double>{1, 2.7});
    }

    SECTION("Copy")
    {
      AggregateDataVariant aggregate_copy{aggregate};

      REQUIRE(aggregate.size() == aggregate_copy.size());

      for (size_t i = 0; i < aggregate.size(); ++i) {
        REQUIRE(aggregate[i].index() == aggregate_copy[i].index());
      }

      REQUIRE(std::get<double>(aggregate[0]) == std::get<double>(aggregate_copy[0]));
      REQUIRE(std::get<int64_t>(aggregate[1]) == std::get<int64_t>(aggregate_copy[1]));
      REQUIRE(std::get<std::vector<double>>(aggregate[2]) == std::get<std::vector<double>>(aggregate_copy[2]));
    }
  }
}
