#include <catch2/catch.hpp>

#include <language/PEGGrammar.hpp>
#include <language/ast/ASTNode.hpp>
#include <language/node_processor/FakeProcessor.hpp>
#include <utils/Demangle.hpp>

// clazy:excludeall=non-pod-global-static

TEST_CASE("ASTNode", "[language]")
{
  rang::setControlMode(rang::control::Off);
  SECTION("execute")
  {
    ASTNode ast_node;
    ExecutionPolicy exec_policy;

#ifndef NDEBUG
    REQUIRE_THROWS(ast_node.execute(exec_policy));
#endif   // NDEBUG

    ast_node.m_node_processor = std::make_unique<FakeProcessor>();

    REQUIRE_NOTHROW(ast_node.execute(exec_policy));
  }

  SECTION("name")
  {
    ASTNode ast_node;

    ast_node.set_type<language::name>();

    REQUIRE(ast_node.name() == demangle<language::name>());
  }

  SECTION("string / string_view")
  {
    SECTION("no content")
    {
      ASTNode ast_node;

      REQUIRE(ast_node.string() == "<optimized out>");
      REQUIRE(ast_node.string_view() == "<optimized out>");
    }

    SECTION("has content")
    {
      ASTNode ast_node;
      ast_node.source  = "content";
      auto& source     = ast_node.source;
      ast_node.m_begin = TAO_PEGTL_NAMESPACE::internal::iterator{&source[0]};
      ast_node.m_end   = TAO_PEGTL_NAMESPACE::internal::iterator{&source[source.size()]};

      REQUIRE(ast_node.string() == "content");
      REQUIRE(ast_node.string_view() == "content");
    }

    SECTION("children have content")
    {
      ASTNode ast_node;
      ast_node.source  = "content";
      auto& source     = ast_node.source;
      ast_node.m_begin = TAO_PEGTL_NAMESPACE::internal::iterator{&source[2]};

      {
        std::unique_ptr<ASTNode> child0_node = std::make_unique<ASTNode>();

        child0_node->m_begin = TAO_PEGTL_NAMESPACE::internal::iterator{&source[0]};
        child0_node->m_end   = TAO_PEGTL_NAMESPACE::internal::iterator{&source[3]};

        ast_node.children.emplace_back(std::move(child0_node));
      }

      {
        std::unique_ptr<ASTNode> child1_node = std::make_unique<ASTNode>();

        child1_node->m_begin = TAO_PEGTL_NAMESPACE::internal::iterator{&source[4]};
        child1_node->m_end   = TAO_PEGTL_NAMESPACE::internal::iterator{&source[source.size()]};

        ast_node.children.emplace_back(std::move(child1_node));
      }

      REQUIRE(ast_node.string() == "content");
      REQUIRE(ast_node.string_view() == "content");
    }
  }
}
