#ifndef NUMBERED_BOUNDARY_DESCRIPTOR_HPP
#define NUMBERED_BOUNDARY_DESCRIPTOR_HPP

#include <scheme/IBoundaryDescriptor.hpp>

#include <iostream>

class NumberedBoundaryDescriptor : public IBoundaryDescriptor
{
 private:
  unsigned int m_number;

  std::ostream&
  _write(std::ostream& os) const final
  {
    os << '"' << m_number << '"';
    return os;
  }

  bool
  operator==(const RefId& ref_id) const final
  {
    return m_number == ref_id.tagNumber();
  }

 public:
  Type
  type() const final
  {
    return Type::numbered;
  }

  NumberedBoundaryDescriptor(const NumberedBoundaryDescriptor&) = delete;
  NumberedBoundaryDescriptor(NumberedBoundaryDescriptor&&)      = delete;
  NumberedBoundaryDescriptor(unsigned int number) : m_number(number)
  {
    ;
  }
  virtual ~NumberedBoundaryDescriptor() = default;
};

#endif   // NUMBERED_BOUNDARY_DESCRIPTOR_HPP
