#ifndef CARTESIAN_MESH_BUILDER_HPP
#define CARTESIAN_MESH_BUILDER_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshBuilderBase.hpp>

#include <memory>

class CartesianMeshBuilder : public MeshBuilderBase
{
 private:
  template <size_t Dimension>
  void _buildBoundaryNodeList(const TinyVector<Dimension, uint64_t>& cell_size, ConnectivityDescriptor& descriptor);

  template <size_t Dimension>
  void _buildBoundaryEdgeList(const TinyVector<Dimension, uint64_t>& cell_size, ConnectivityDescriptor& descriptor);

  template <size_t Dimension>
  void _buildBoundaryFaceList(const TinyVector<Dimension, uint64_t>& cell_size, ConnectivityDescriptor& descriptor);

  template <size_t Dimension>
  void _buildCartesianMesh(const TinyVector<Dimension>& a,
                           const TinyVector<Dimension>& b,
                           const TinyVector<Dimension, uint64_t>& size);

 public:
  template <size_t Dimension>
  CartesianMeshBuilder(const TinyVector<Dimension>& a,
                       const TinyVector<Dimension>& b,
                       const TinyVector<Dimension, uint64_t>& size);
  ~CartesianMeshBuilder() = default;
};

#endif   // CARTESIAN_MESH_BUILDER_HPP
