#include <language/ast/ASTNodeFunctionEvaluationExpressionBuilder.hpp>

#include <language/ast/ASTNodeBuiltinFunctionExpressionBuilder.hpp>
#include <language/ast/ASTNodeFunctionExpressionBuilder.hpp>
#include <language/utils/SymbolTable.hpp>

ASTNodeFunctionEvaluationExpressionBuilder::ASTNodeFunctionEvaluationExpressionBuilder(ASTNode& node)
{
  auto [i_function_symbol, found] = node.m_symbol_table->find(node.children[0]->string(), node.begin());
  Assert(found);

  switch (i_function_symbol->attributes().dataType()) {
  case ASTNodeDataType::function_t: {
    ASTNodeFunctionExpressionBuilder{node};
    break;
  }
  case ASTNodeDataType::builtin_function_t: {
    ASTNodeBuiltinFunctionExpressionBuilder{node};
    break;
  }
    //    LCOV_EXCL_START
  default: {
    throw parse_error("unexpected function type", node.begin());
  }
    //    LCOV_EXCL_STOP
  }
}
