# Looking for ParMETIS

find_path(PARMETIS_INCLUDE_DIR parmetis.h
  PATH_SUFFIX include parmetis)

if (EXISTS "${PARMETIS_INCLUDE_DIR}/parmetis.h")
  message("-- Found parmetis.h in ${PARMETIS_INCLUDE_DIR}")
  find_library(LIB_PARMETIS parmetis)
  if("${LIB_PARMETIS}" STREQUAL "LIB_PARMETIS-NOTFOUND")
    message(WARNING "Could not find parmetis library")
  endif()
  find_library(LIB_METIS metis)
  if("${LIB_PARMETIS}" STREQUAL "LIB_METIS-NOTFOUND")
    message(WARNING "Could not find metis library")
  endif()
  set(PARMETIS_LIBRARIES ${LIB_PARMETIS} ${LIB_METIS})
  message("-- Found parmetis/metis libraries ${PARMETIS_LIBRARIES}")
else()
  message(WARNING "Could not find parmetis.h")
endif()

mark_as_advanced(PARMETIS_INCLUDE_DIR PARMETIS_LIBRARIES)
