#ifndef I_NODE_PROCESSOR_HPP
#define I_NODE_PROCESSOR_HPP

#include <Demangle.hpp>
#include <node_processor/ExecutionPolicy.hpp>

#include <string>
#include <typeinfo>

#include <DataVariant.hpp>

struct INodeProcessor
{
  virtual DataVariant execute(ExecutionPolicy& exec_policy) = 0;

  std::string
  typeIdName() const
  {
    return demangle(typeid(*this).name());
  }

  INodeProcessor(const INodeProcessor&) = delete;

  INodeProcessor() = default;

  virtual ~INodeProcessor() = default;
};

#endif   // I_NODE_PROCESSOR_HPP
