#ifndef PASTIS_MACROS_HPP
#define PASTIS_MACROS_HPP

#include <Kokkos_Macros.hpp>

#define PASTIS_RESTRICT KOKKOS_RESTRICT

#define PASTIS_INLINE KOKKOS_INLINE_FUNCTION
#define PASTIS_FORCEINLINE KOKKOS_FORCEINLINE_FUNCTION

#define PASTIS_LAMBDA KOKKOS_LAMBDA

// Sets macro to ignore unknown pragma

#if !defined(__clang__) and defined(__GNUC__)

#define PRAGMA_DIAGNOSTIC_IGNORED_WATTRIBUTES           \
  _Pragma ("GCC diagnostic ignored \"-Wattributes\"")
#define PRAGMA_DIAGNOSTIC_POP                   \
  _Pragma ("GCC diagnostic pop")

#else // !defined(__clang__) and defined(__GNUC__)

#define PRAGMA_DIAGNOSTIC_IGNORED_WATTRIBUTES
#define PRAGMA_DIAGNOSTIC_POP

#endif

#endif // PASTIS_MACROS_HPP
