#ifndef DISCRETE_FUNCTION_VECTOR_INTEGRATOR_HPP
#define DISCRETE_FUNCTION_VECTOR_INTEGRATOR_HPP

#include <analysis/IQuadratureDescriptor.hpp>
#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <mesh/IZoneDescriptor.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

#include <memory>
#include <vector>

class DiscreteFunctionVectorIntegrator
{
 private:
  std::shared_ptr<const IMesh> m_mesh;
  const std::vector<std::shared_ptr<const IZoneDescriptor>> m_zone_list;
  std::shared_ptr<const IQuadratureDescriptor> m_quadrature_descriptor;
  std::shared_ptr<const IDiscreteFunctionDescriptor> m_discrete_function_descriptor;
  const std::vector<FunctionSymbolId> m_function_id_list;

  template <size_t Dimension, typename DataType>
  std::shared_ptr<IDiscreteFunction> _integrateOnZoneList() const;

  template <size_t Dimension, typename DataType>
  std::shared_ptr<IDiscreteFunction> _integrateGlobally() const;

  template <size_t Dimension, typename DataType>
  std::shared_ptr<IDiscreteFunction> _integrate() const;

  template <size_t Dimension>
  std::shared_ptr<IDiscreteFunction> _integrate() const;

 public:
  std::shared_ptr<IDiscreteFunction> integrate() const;

  DiscreteFunctionVectorIntegrator(
    const std::shared_ptr<const IMesh>& mesh,
    const std::shared_ptr<const IQuadratureDescriptor>& quadrature_descriptor,
    const std::shared_ptr<const IDiscreteFunctionDescriptor>& discrete_function_descriptor,
    const std::vector<FunctionSymbolId>& function_id_list)
    : m_mesh{mesh},
      m_quadrature_descriptor(quadrature_descriptor),
      m_discrete_function_descriptor{discrete_function_descriptor},
      m_function_id_list{function_id_list}
  {}

  DiscreteFunctionVectorIntegrator(
    const std::shared_ptr<const IMesh>& mesh,
    const std::vector<std::shared_ptr<const IZoneDescriptor>>& zone_list,
    const std::shared_ptr<const IQuadratureDescriptor>& quadrature_descriptor,
    const std::shared_ptr<const IDiscreteFunctionDescriptor>& discrete_function_descriptor,
    const std::vector<FunctionSymbolId>& function_id_list)
    : m_mesh{mesh},
      m_zone_list{zone_list},
      m_quadrature_descriptor(quadrature_descriptor),
      m_discrete_function_descriptor{discrete_function_descriptor},
      m_function_id_list{function_id_list}
  {}

  DiscreteFunctionVectorIntegrator(const DiscreteFunctionVectorIntegrator&) = delete;
  DiscreteFunctionVectorIntegrator(DiscreteFunctionVectorIntegrator&&)      = delete;

  ~DiscreteFunctionVectorIntegrator() = default;
};

#endif   // DISCRETE_FUNCTION_VECTOR_INTEGRATOR_HPP
