#include <mesh/MedianDualMeshBuilder.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/DualConnectivityManager.hpp>
#include <mesh/ItemValueUtils.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/PrimalToMedianDualConnectivityDataMapper.hpp>

template <size_t Dimension>
void
MedianDualMeshBuilder::_buildMedianDualMeshFrom(const IMesh& i_mesh)
{
  static_assert(Dimension > 1);

  using ConnectivityType = Connectivity<Dimension>;
  using MeshType         = Mesh<Connectivity<Dimension>>;

  const MeshType& primal_mesh = dynamic_cast<const MeshType&>(i_mesh);

  DualConnectivityManager& manager = DualConnectivityManager::instance();

  std::shared_ptr<const ConnectivityType> p_dual_connectivity =
    manager.getMedianDualConnectivity(primal_mesh.connectivity());

  const ConnectivityType& dual_connectivity = *p_dual_connectivity;

  const NodeValue<const TinyVector<Dimension>> primal_xr = primal_mesh.xr();

  MeshData<Dimension>& primal_mesh_data                  = MeshDataManager::instance().getMeshData(primal_mesh);
  const CellValue<const TinyVector<Dimension>> primal_xj = primal_mesh_data.xj();
  const FaceValue<const TinyVector<Dimension>> primal_xl = primal_mesh_data.xl();

  std::shared_ptr primal_to_dual_connectivity_data_mapper =
    manager.getPrimalToMedianDualConnectivityDataMapper(primal_mesh.connectivity());

  NodeValue<TinyVector<Dimension>> dual_xr{dual_connectivity};
  primal_to_dual_connectivity_data_mapper->toDualNode(primal_xr, primal_xl, primal_xj, dual_xr);

  m_mesh = std::make_shared<MeshType>(p_dual_connectivity, dual_xr);
}

MedianDualMeshBuilder::MedianDualMeshBuilder(const IMesh& i_mesh)
{
  switch (i_mesh.dimension()) {
  case 2: {
    this->_buildMedianDualMeshFrom<2>(i_mesh);
    break;
  }
  case 3: {
    throw NotImplementedError("median dual mesh");
    break;
  }
    // LCOV_EXCL_START
  default: {
    throw UnexpectedError("invalid mesh dimension: " + std::to_string(i_mesh.dimension()));
  }
    // LCOV_EXCL_STOP
  }
}
