#ifndef INFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define INFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class InflowBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "inflow(" << ',' << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;
  const FunctionSymbolId m_function_symbol_id;

 public:
  FunctionSymbolId
  functionSymbolId() const
  {
    return m_function_symbol_id;
  }

  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::inflow;
  }

  InflowBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor,
                                    const FunctionSymbolId& function_symbol_id)
    : m_boundary_descriptor(boundary_descriptor), m_function_symbol_id{function_symbol_id}
  {
    ;
  }

  InflowBoundaryConditionDescriptor(const InflowBoundaryConditionDescriptor&) = delete;
  InflowBoundaryConditionDescriptor(InflowBoundaryConditionDescriptor&&)      = delete;

  ~InflowBoundaryConditionDescriptor() = default;
};

#endif   // INFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP
