#ifndef MESH_VARIANT_HPP
#define MESH_VARIANT_HPP

#include <utils/PugsMacros.hpp>

#include <iostream>
#include <memory>
#include <variant>

template <size_t>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

class MeshVariant
{
 private:
  using Variant = std::variant<std::shared_ptr<const Mesh<Connectivity<1>>>,
                               std::shared_ptr<const Mesh<Connectivity<2>>>,
                               std::shared_ptr<const Mesh<Connectivity<3>>>>;

  Variant m_p_mesh;

 public:
  friend std::ostream& operator<<(std::ostream& os, const MeshVariant& mesh_v);

  size_t id() const;

  template <typename MeshType>
  PUGS_INLINE std::shared_ptr<const MeshType>
  get() const
  {
    return std::get<std::shared_ptr<const MeshType>>(m_p_mesh);
  }

  PUGS_INLINE
  Variant
  meshPointer() const
  {
    return m_p_mesh;
  }

  MeshVariant() = delete;

  template <typename MeshType>
  MeshVariant(const std::shared_ptr<const MeshType>& p_mesh) : m_p_mesh{p_mesh}
  {}

  MeshVariant(const MeshVariant&) = default;
  MeshVariant(MeshVariant&&)      = default;

  ~MeshVariant() = default;
};

#endif   // MESH_VARIANT_HPP
