#include <mesh/MeshVariant.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/Mesh.hpp>

size_t
MeshVariant::id() const
{
  return std::visit([](auto&& mesh) { return mesh->id(); }, m_p_mesh);
}

std::ostream&
operator<<(std::ostream& os, const MeshVariant& mesh_v)
{
  std::visit([&](auto&& p_mesh) { os << *p_mesh; }, mesh_v.meshPointer());
  return os;
}
