#ifndef MESH_TRAITS_HPP
#define MESH_TRAITS_HPP

#include <cstddef>

template <size_t>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <typename MeshType>
constexpr inline bool is_polygonal_mesh = false;

template <size_t Dimension>
constexpr inline bool is_polygonal_mesh<Mesh<Connectivity<Dimension>>> = true;

template <size_t Dimension>
constexpr inline bool is_polygonal_mesh<const Mesh<Connectivity<Dimension>>> = true;

#endif   // MESH_TRAITS_HPP
