#ifndef MESH_RELAXER_HPP
#define MESH_RELAXER_HPP

class MeshVariant;

template <typename ConnectivityType>
class Mesh;

#include <memory>

class MeshRelaxer
{
 private:
  template <typename MeshType>
  std::shared_ptr<const MeshVariant> _relax(const MeshType& source_mesh,
                                            const MeshType& destination_mesh,
                                            const double& theta) const;

 public:
  std::shared_ptr<const MeshVariant> relax(const std::shared_ptr<const MeshVariant>& p_source_mesh,
                                           const std::shared_ptr<const MeshVariant>& p_destination_mesh,
                                           const double& theta) const;
  MeshRelaxer()  = default;
  ~MeshRelaxer() = default;
};

#endif   // MESH_RELAXER_HPP
