#ifndef MESH_LINE_FACE_BOUNDARY_HPP
#define MESH_LINE_FACE_BOUNDARY_HPP

#include <algebra/TinyMatrix.hpp>
#include <mesh/MeshFaceBoundary.hpp>

template <size_t Dimension>
class [[nodiscard]] MeshLineFaceBoundary final
  : public MeshFaceBoundary<Dimension>   // clazy:exclude=copyable-polymorphic
{
 public:
  static_assert(Dimension == 2, "MeshLineFaceBoundary makes only sense in dimension 2");

  using Rd = TinyVector<Dimension, double>;

 private:
  const Rd m_direction;

 public:
  template <size_t MeshDimension>
  friend MeshLineFaceBoundary<MeshDimension> getMeshLineFaceBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                                     const IBoundaryDescriptor& boundary_descriptor);

  PUGS_INLINE
  const Rd& direction() const
  {
    return m_direction;
  }

  MeshLineFaceBoundary& operator=(const MeshLineFaceBoundary&) = default;
  MeshLineFaceBoundary& operator=(MeshLineFaceBoundary&&) = default;

 private:
  MeshLineFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list, const Rd& direction)
    : MeshFaceBoundary<Dimension>(mesh, ref_face_list), m_direction(direction)
  {}

 public:
  MeshLineFaceBoundary()                            = default;
  MeshLineFaceBoundary(const MeshLineFaceBoundary&) = default;
  MeshLineFaceBoundary(MeshLineFaceBoundary &&)     = default;
  ~MeshLineFaceBoundary()                           = default;
};

template <size_t Dimension>
MeshLineFaceBoundary<Dimension> getMeshLineFaceBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                        const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_LINE_FACE_BOUNDARY_HPP
