#ifndef MESH_FLAT_EDGE_BOUNDARY_HPP
#define MESH_FLAT_EDGE_BOUNDARY_HPP

#include <mesh/MeshEdgeBoundary.hpp>

template <size_t Dimension>
class MeshFlatEdgeBoundary final : public MeshEdgeBoundary<Dimension>   // clazy:exclude=copyable-polymorphic
{
 public:
  using Rd = TinyVector<Dimension, double>;

 private:
  const Rd m_outgoing_normal;

 public:
  const Rd&
  outgoingNormal() const
  {
    return m_outgoing_normal;
  }

  MeshFlatEdgeBoundary& operator=(const MeshFlatEdgeBoundary&) = default;
  MeshFlatEdgeBoundary& operator=(MeshFlatEdgeBoundary&&) = default;

  template <size_t MeshDimension>
  friend MeshFlatEdgeBoundary<MeshDimension> getMeshFlatEdgeBoundary(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                                     const IBoundaryDescriptor& boundary_descriptor);

 private:
  template <typename MeshType>
  MeshFlatEdgeBoundary(const MeshType& mesh, const RefEdgeList& ref_edge_list, const Rd& outgoing_normal)
    : MeshEdgeBoundary<Dimension>(mesh, ref_edge_list), m_outgoing_normal(outgoing_normal)
  {}

 public:
  MeshFlatEdgeBoundary()                            = default;
  MeshFlatEdgeBoundary(const MeshFlatEdgeBoundary&) = default;
  MeshFlatEdgeBoundary(MeshFlatEdgeBoundary&&)      = default;
  ~MeshFlatEdgeBoundary()                           = default;
};

template <size_t Dimension>
MeshFlatEdgeBoundary<Dimension> getMeshFlatEdgeBoundary(const Mesh<Connectivity<Dimension>>& mesh,
                                                        const IBoundaryDescriptor& boundary_descriptor);

#endif   // MESH_FLAT_EDGE_BOUNDARY_HPP
