#ifndef MESH_BUILDER_BASE_HPP
#define MESH_BUILDER_BASE_HPP

class MeshVariant;

#include <memory>

class MeshBuilderBase
{
 protected:
  std::shared_ptr<const MeshVariant> m_mesh;

  template <size_t Dimension>
  void _dispatch();

  template <size_t Dimension>
  void _checkMesh() const;

 public:
  std::shared_ptr<const MeshVariant>
  mesh() const
  {
    return m_mesh;
  }

  MeshBuilderBase()  = default;
  ~MeshBuilderBase() = default;
};

#endif   // MESH_BUILDER_BASE_HPP
