#ifndef ACOUSTIC_SOLVER_HPP
#define ACOUSTIC_SOLVER_HPP

#include <Kokkos_Core.hpp>

class AcousticSolver 
{
private:

  inline double e(double rho, double p, double gamma) const;
  inline double p(double rho, double e, double gamma) const;

  inline double acoustic_dt(const Kokkos::View<const double*>& Vj,
			    const Kokkos::View<const double*>& cj) const;

  inline void computeExplicitFluxes(const Kokkos::View<const double*>& xr,
				    const Kokkos::View<const double*>& xj,
				    const Kokkos::View<const double*>& rhoj,
				    const Kokkos::View<const double*>& uj,
				    const Kokkos::View<const double*>& pj,
				    const Kokkos::View<const double*>& cj,
				    const Kokkos::View<const double*>& Vj,
				    const Kokkos::View<const int*[2]>& node_cells,
				    const Kokkos::View<const int*>& node_nb_cells,
				    const Kokkos::View<const int*[2]> node_cell_local_node,
				    Kokkos::View<double*>& ur,
				    Kokkos::View<double*>& pr) const;

  struct ReduceMin;
public:
  AcousticSolver(const long int& nj);
};

#endif // ACOUSTIC_SOLVER_HPP
