#ifndef OUTFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define OUTFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class OutflowBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "outflow(" << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::outflow;
  }

  OutflowBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {
    ;
  }

  OutflowBoundaryConditionDescriptor(const OutflowBoundaryConditionDescriptor&) = delete;
  OutflowBoundaryConditionDescriptor(OutflowBoundaryConditionDescriptor&&)      = delete;

  ~OutflowBoundaryConditionDescriptor() = default;
};

#endif   // OUTFLOW_BOUNDARY_CONDITION_DESCRIPTOR_HPP
