#ifndef FIXED_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define FIXED_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class FixedBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "fixed(" << *m_boundary_descriptor << ")";
    return os;
  }

  const std::string_view m_name;

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::fixed;
  }

  FixedBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {}

  FixedBoundaryConditionDescriptor(const FixedBoundaryConditionDescriptor&) = delete;
  FixedBoundaryConditionDescriptor(FixedBoundaryConditionDescriptor&&)      = delete;

  ~FixedBoundaryConditionDescriptor() = default;
};
#endif   // FIXED_BOUNDARY_CONDITION_DESCRIPTOR_HPP
