#ifndef DISCRETE_FUNCTION_INTEGRATOR_HPP
#define DISCRETE_FUNCTION_INTEGRATOR_HPP

#include <analysis/IQuadratureDescriptor.hpp>
#include <language/utils/FunctionSymbolId.hpp>
#include <mesh/IMesh.hpp>
#include <mesh/IZoneDescriptor.hpp>

#include <memory>

class DiscreteFunctionVariant;

class DiscreteFunctionIntegrator
{
 private:
  std::shared_ptr<const IMesh> m_mesh;
  const std::vector<std::shared_ptr<const IZoneDescriptor>> m_zone_list;
  std::shared_ptr<const IQuadratureDescriptor> m_quadrature_descriptor;
  const FunctionSymbolId m_function_id;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  DiscreteFunctionVariant _integrateOnZoneList() const;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  DiscreteFunctionVariant _integrateGlobally() const;

  template <size_t Dimension, typename DataType, typename ValueType = DataType>
  DiscreteFunctionVariant _integrate() const;

  template <size_t Dimension>
  DiscreteFunctionVariant _integrate() const;

 public:
  DiscreteFunctionVariant integrate() const;

  DiscreteFunctionIntegrator(const std::shared_ptr<const IMesh>& mesh,
                             const std::shared_ptr<const IQuadratureDescriptor>& quadrature_descriptor,
                             const FunctionSymbolId& function_id)
    : m_mesh{mesh}, m_quadrature_descriptor{quadrature_descriptor}, m_function_id{function_id}
  {}

  DiscreteFunctionIntegrator(const std::shared_ptr<const IMesh>& mesh,
                             const std::vector<std::shared_ptr<const IZoneDescriptor>>& zone_list,
                             const std::shared_ptr<const IQuadratureDescriptor>& quadrature_descriptor,
                             const FunctionSymbolId& function_id)
    : m_mesh{mesh}, m_zone_list{zone_list}, m_quadrature_descriptor{quadrature_descriptor}, m_function_id{function_id}
  {}

  DiscreteFunctionIntegrator(const DiscreteFunctionIntegrator&) = delete;
  DiscreteFunctionIntegrator(DiscreteFunctionIntegrator&&)      = delete;

  ~DiscreteFunctionIntegrator() = default;
};

#endif   // DISCRETE_FUNCTION_INTEGRATOR_HPP
