#pragma once
#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/IBoundaryConditionDescriptor.hpp>

#include <memory>

class CouplingBoundaryConditionDescriptor : public IBoundaryConditionDescriptor
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "coupling(" << *m_boundary_descriptor << ")";
    return os;
  }

  std::shared_ptr<const IBoundaryDescriptor> m_boundary_descriptor;

 public:
  const IBoundaryDescriptor&
  boundaryDescriptor() const final
  {
    return *m_boundary_descriptor;
  }

  Type
  type() const final
  {
    return Type::coupling;
  }

  CouplingBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor)
    : m_boundary_descriptor(boundary_descriptor)
  {
    ;
  }

  CouplingBoundaryConditionDescriptor(const CouplingBoundaryConditionDescriptor&) = delete;
  CouplingBoundaryConditionDescriptor(CouplingBoundaryConditionDescriptor&&)      = delete;

  ~CouplingBoundaryConditionDescriptor() = default;
};
