#ifndef OSTREAM_PROCESSOR_HPP
#define OSTREAM_PROCESSOR_HPP

#include <language/ast/ASTNode.hpp>
#include <language/node_processor/INodeProcessor.hpp>
#include <language/utils/ParseError.hpp>

class OStreamProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  std::ostream& m_os;

 public:
  DataVariant
  execute(ExecutionPolicy& exec_policy)
  {
    for (size_t i = 0; i < m_node.children.size(); ++i) {
      m_os << m_node.children[i]->execute(exec_policy);
    }

    return {};
  }

  OStreamProcessor(ASTNode& node, std::ostream& os) : m_node{node}, m_os(os)
  {
    for (auto& child : m_node.children) {
      if ((child->m_data_type == ASTNodeDataType::type_name_id_t) or
          (child->m_data_type == ASTNodeDataType::function_t) or
          (child->m_data_type == ASTNodeDataType::builtin_function_t)) {
        throw ParseError("invalid argument, cannot print a '" + dataTypeName(child->m_data_type) + "'",
                         std::vector{child->begin()});
      }
    }
  }
};

#endif   // OSTREAM_PROCESSOR_HPP
