#ifndef WRITER_MODULE_HPP
#define WRITER_MODULE_HPP

#include <language/modules/BuiltinModule.hpp>
#include <language/utils/ASTNodeDataTypeTraits.hpp>
#include <utils/PugsMacros.hpp>

class OutputNamedItemValueSet;
class NamedDiscreteFunction;
class IDiscreteFunction;

#include <string>

template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const NamedDiscreteFunction>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("output");

class IWriter;
template <>
inline ASTNodeDataType ast_node_data_type_from<std::shared_ptr<const IWriter>> =
  ASTNodeDataType::build<ASTNodeDataType::type_id_t>("writer");

class WriterModule : public BuiltinModule
{
 public:
  std::string_view
  name() const final
  {
    return "writer";
  }

  WriterModule();

  ~WriterModule() = default;
};

#endif   // WRITER_MODULE_HPP
