#ifndef ORDER2_HYPERELASTIC_SOLVER_HPP
#define ORDER2_HYPERELASTIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;
class DiscreteFunctionVariant;

class Order2HyperelasticSolverHandler
{
 public:
  enum class SolverType
  {
    Glace,
    Eucclhyd
  };

 private:
  struct IOrder2HyperelasticSolver
  {
    virtual std::tuple<const std::shared_ptr<const ItemValueVariant>,
                       const std::shared_ptr<const SubItemValuePerItemVariant>>
    compute_fluxes(
      const SolverType& solver_type,
      const std::shared_ptr<const DiscreteFunctionVariant>& rho,
      const std::shared_ptr<const DiscreteFunctionVariant>& aL,
      const std::shared_ptr<const DiscreteFunctionVariant>& aT,
      const std::shared_ptr<const DiscreteFunctionVariant>& u,
      const std::shared_ptr<const DiscreteFunctionVariant>& sigma,
      const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply_fluxes(const double& dt,
                 const std::shared_ptr<const DiscreteFunctionVariant>& rho,
                 const std::shared_ptr<const DiscreteFunctionVariant>& u,
                 const std::shared_ptr<const DiscreteFunctionVariant>& E,
                 const std::shared_ptr<const DiscreteFunctionVariant>& CG,
                 const std::shared_ptr<const ItemValueVariant>& ur,
                 const std::shared_ptr<const SubItemValuePerItemVariant>& Fjr) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const SolverType& solver_type,
          const size_t& law,
          const double& dt,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho,
          const std::shared_ptr<const DiscreteFunctionVariant>& u,
          const std::shared_ptr<const DiscreteFunctionVariant>& E,
          const std::shared_ptr<const DiscreteFunctionVariant>& CG,
          const std::shared_ptr<const DiscreteFunctionVariant>& aL,
          const std::shared_ptr<const DiscreteFunctionVariant>& aT,
          const std::shared_ptr<const DiscreteFunctionVariant>& sigma,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list,
          const std::shared_ptr<const DiscreteFunctionVariant>& chi_solid,
          const double& lambda,
          const double& mu,
          const double& gamma_f,
          const double& p_inf_f,
          const double& gamma_s,
          const double& p_inf_s) const = 0;

    IOrder2HyperelasticSolver()                      = default;
    IOrder2HyperelasticSolver(IOrder2HyperelasticSolver&&) = default;
    IOrder2HyperelasticSolver& operator=(IOrder2HyperelasticSolver&&) = default;

    virtual ~IOrder2HyperelasticSolver() = default;
  };

  template <MeshConcept MeshType>
  class Order2HyperelasticSolver;

  std::unique_ptr<IOrder2HyperelasticSolver> m_hyperelastic_solver;

 public:
  const IOrder2HyperelasticSolver&
  solver() const
  {
    return *m_hyperelastic_solver;
  }

  Order2HyperelasticSolverHandler(const std::shared_ptr<const MeshVariant>& mesh);
};

#endif   // HYPERELASTIC_SOLVER_HPP
