#ifndef LOCAL_DT_HYPERELASTIC_SOLVER_HPP
#define LOCAL_DT_HYPERELASTIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;
class DiscreteFunctionVariant;

class LocalDtHyperelasticSolverHandler
{
 public:
  enum class SolverType
  {
    Glace,
    Eucclhyd
  };

 private:
  struct ILocalDtHyperelasticSolver
  {
    virtual std::tuple<const std::shared_ptr<const ItemValueVariant>,
                       const std::shared_ptr<const SubItemValuePerItemVariant>>
    compute_fluxes(
      const SolverType& solver_type,
      const std::shared_ptr<const DiscreteFunctionVariant>& rho,
      const std::shared_ptr<const DiscreteFunctionVariant>& aL,
      const std::shared_ptr<const DiscreteFunctionVariant>& aT,
      const std::shared_ptr<const DiscreteFunctionVariant>& u,
      const std::shared_ptr<const DiscreteFunctionVariant>& sigma,
      const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply_fluxes(const double& dt,
                 const std::shared_ptr<const DiscreteFunctionVariant>& rho,
                 const std::shared_ptr<const DiscreteFunctionVariant>& u,
                 const std::shared_ptr<const DiscreteFunctionVariant>& E,
                 const std::shared_ptr<const DiscreteFunctionVariant>& CG,
                 const std::shared_ptr<const ItemValueVariant>& ur,
                 const std::shared_ptr<const SubItemValuePerItemVariant>& Fjr) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const SolverType& solver_type,
          const double& dt1,
          const size_t& q,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho1,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho2,
          const std::shared_ptr<const DiscreteFunctionVariant>& u1,
          const std::shared_ptr<const DiscreteFunctionVariant>& u2,
          const std::shared_ptr<const DiscreteFunctionVariant>& E1,
          const std::shared_ptr<const DiscreteFunctionVariant>& E2,
          const std::shared_ptr<const DiscreteFunctionVariant>& CG1,
          const std::shared_ptr<const DiscreteFunctionVariant>& CG2,
          const std::shared_ptr<const DiscreteFunctionVariant>& aL1,
          const std::shared_ptr<const DiscreteFunctionVariant>& aL2,
          const std::shared_ptr<const DiscreteFunctionVariant>& aT1,
          const std::shared_ptr<const DiscreteFunctionVariant>& aT2,
          const std::shared_ptr<const DiscreteFunctionVariant>& sigma1,
          const std::shared_ptr<const DiscreteFunctionVariant>& sigma2,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list1,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list2,
          const double& mu,
          const double& lambda) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
  apply(const SolverType& solver_type,
        const double& dt1,
        const std::shared_ptr<const DiscreteFunctionVariant>& rho1,
        const std::shared_ptr<const DiscreteFunctionVariant>& rho2,
        const std::shared_ptr<const DiscreteFunctionVariant>& u1,
        const std::shared_ptr<const DiscreteFunctionVariant>& u2,
        const std::shared_ptr<const DiscreteFunctionVariant>& E1,
        const std::shared_ptr<const DiscreteFunctionVariant>& E2,
        const std::shared_ptr<const DiscreteFunctionVariant>& CG1,
        const std::shared_ptr<const DiscreteFunctionVariant>& CG2,
        const std::shared_ptr<const DiscreteFunctionVariant>& aL1,
        const std::shared_ptr<const DiscreteFunctionVariant>& aL2,
        const std::shared_ptr<const DiscreteFunctionVariant>& aT1,
        const std::shared_ptr<const DiscreteFunctionVariant>& aT2,
        const std::shared_ptr<const DiscreteFunctionVariant>& sigma1,
        const std::shared_ptr<const DiscreteFunctionVariant>& sigma2,
        const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list1,
        const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list2,
        const double& mu,
        const double& lambda) const = 0;

    ILocalDtHyperelasticSolver()                                        = default;
    ILocalDtHyperelasticSolver(ILocalDtHyperelasticSolver&&)            = default;
    ILocalDtHyperelasticSolver& operator=(ILocalDtHyperelasticSolver&&) = default;

    virtual ~ILocalDtHyperelasticSolver() = default;
  };

  template <MeshConcept MeshType>
  class LocalDtHyperelasticSolver;

  std::unique_ptr<ILocalDtHyperelasticSolver> m_hyperelastic_solver;

 public:
  const ILocalDtHyperelasticSolver&
  solver() const
  {
    return *m_hyperelastic_solver;
  }

  LocalDtHyperelasticSolverHandler(const std::shared_ptr<const MeshVariant>& mesh1,
                                   const std::shared_ptr<const MeshVariant>& mesh2);
};

#endif   // HYPERELASTIC_SOLVER_HPP
