#ifndef LOCAL_DT_ACOUSTIC_SOLVER_HPP
#define LOCAL_DT_ACOUSTIC_SOLVER_HPP

#include <mesh/MeshTraits.hpp>

#include <memory>
#include <tuple>
#include <vector>

class DiscreteFunctionVariant;
class IBoundaryConditionDescriptor;
class MeshVariant;
class ItemValueVariant;
class SubItemValuePerItemVariant;

class LocalDtAcousticSolverHandler
{
 public:
  enum class SolverType
  {
    Glace,
    Eucclhyd
  };

 private:
  struct ILocalDtAcousticSolver
  {
    virtual std::tuple<const std::shared_ptr<const ItemValueVariant>,
                       const std::shared_ptr<const SubItemValuePerItemVariant>>
    compute_fluxes(
      const SolverType& solver_type,
      const std::shared_ptr<const DiscreteFunctionVariant>& rho,
      const std::shared_ptr<const DiscreteFunctionVariant>& c,
      const std::shared_ptr<const DiscreteFunctionVariant>& u,
      const std::shared_ptr<const DiscreteFunctionVariant>& p,
      const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply_fluxes(const double& dt,
                 const std::shared_ptr<const DiscreteFunctionVariant>& rho,
                 const std::shared_ptr<const DiscreteFunctionVariant>& u,
                 const std::shared_ptr<const DiscreteFunctionVariant>& E,
                 const std::shared_ptr<const ItemValueVariant>& ur,
                 const std::shared_ptr<const SubItemValuePerItemVariant>& Fjr) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const SolverType& solver_type,
          const double& dt1,
          const size_t& q,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho1,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho2,
          const std::shared_ptr<const DiscreteFunctionVariant>& u1,
          const std::shared_ptr<const DiscreteFunctionVariant>& u2,
          const std::shared_ptr<const DiscreteFunctionVariant>& E1,
          const std::shared_ptr<const DiscreteFunctionVariant>& E2,
          const std::shared_ptr<const DiscreteFunctionVariant>& c1,
          const std::shared_ptr<const DiscreteFunctionVariant>& c2,
          const std::shared_ptr<const DiscreteFunctionVariant>& p1,
          const std::shared_ptr<const DiscreteFunctionVariant>& p2,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list1,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list2) const = 0;

    virtual std::tuple<std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const MeshVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>,
                       std::shared_ptr<const DiscreteFunctionVariant>>
    apply(const SolverType& solver_type,
          const double& dt1,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho1,
          const std::shared_ptr<const DiscreteFunctionVariant>& rho2,
          const std::shared_ptr<const DiscreteFunctionVariant>& u1,
          const std::shared_ptr<const DiscreteFunctionVariant>& u2,
          const std::shared_ptr<const DiscreteFunctionVariant>& E1,
          const std::shared_ptr<const DiscreteFunctionVariant>& E2,
          const std::shared_ptr<const DiscreteFunctionVariant>& c1,
          const std::shared_ptr<const DiscreteFunctionVariant>& c2,
          const std::shared_ptr<const DiscreteFunctionVariant>& p1,
          const std::shared_ptr<const DiscreteFunctionVariant>& p2,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list1,
          const std::vector<std::shared_ptr<const IBoundaryConditionDescriptor>>& bc_descriptor_list2) const = 0;

    ILocalDtAcousticSolver()                                    = default;
    ILocalDtAcousticSolver(ILocalDtAcousticSolver&&)            = default;
    ILocalDtAcousticSolver& operator=(ILocalDtAcousticSolver&&) = default;

    virtual ~ILocalDtAcousticSolver() = default;
  };

  template <MeshConcept MeshType>
  class LocalDtAcousticSolver;

  std::unique_ptr<ILocalDtAcousticSolver> m_acoustic_solver;

 public:
  const ILocalDtAcousticSolver&
  solver() const
  {
    return *m_acoustic_solver;
  }

  LocalDtAcousticSolverHandler(const std::shared_ptr<const MeshVariant>& mesh1,
                               const std::shared_ptr<const MeshVariant>& mesh2);
};

#endif   // LOCAL_DT_ACOUSTIC_SOLVER_HPP
