#ifndef COUPLING_BOUNDARY_CONDITION_DESCRIPTOR_HPP
#define COUPLING_BOUNDARY_CONDITION_DESCRIPTOR_HPP

#include <mesh/IBoundaryDescriptor.hpp>
#include <scheme/BoundaryConditionDescriptorBase.hpp>

#include <memory>

class CouplingBoundaryConditionDescriptor : public BoundaryConditionDescriptorBase
{
 private:
  std::ostream&
  _write(std::ostream& os) const final
  {
    os << "coupling(" << *m_boundary_descriptor << ")";
    return os;
  }

  size_t m_label;

 public:
  Type
  type() const final
  {
    return Type::coupling;
  }

  size_t
  label() const
  {
    return m_label;
  }

  CouplingBoundaryConditionDescriptor(std::shared_ptr<const IBoundaryDescriptor> boundary_descriptor, size_t label)
    : BoundaryConditionDescriptorBase(boundary_descriptor), m_label{label}
  {
    ;
  }

  CouplingBoundaryConditionDescriptor(const CouplingBoundaryConditionDescriptor&) = delete;
  CouplingBoundaryConditionDescriptor(CouplingBoundaryConditionDescriptor&&)      = delete;

  ~CouplingBoundaryConditionDescriptor() = default;
};

#endif   // COUPLING_BOUNDARY_CONDITION_DESCRIPTOR_HPP
