#ifndef BUILTIN_MODULE_HPP
#define BUILTIN_MODULE_HPP

#include <language/ast/ASTNodeDataType.hpp>
#include <language/modules/IModule.hpp>

class IBuiltinFunctionEmbedder;
class TypeDescriptor;

class BuiltinModule : public IModule
{
 protected:
  NameBuiltinFunctionMap m_name_builtin_function_map;
  NameTypeMap m_name_type_map;

  void _addBuiltinFunction(const std::string& name,
                           std::shared_ptr<IBuiltinFunctionEmbedder> builtin_function_embedder);

  void _addTypeDescriptor(const ASTNodeDataType& type);

 public:
  const NameBuiltinFunctionMap&
  getNameBuiltinFunctionMap() const final
  {
    return m_name_builtin_function_map;
  }

  const NameTypeMap&
  getNameTypeMap() const final
  {
    return m_name_type_map;
  }

  BuiltinModule() = default;

  ~BuiltinModule() = default;
};

#endif   // BUILTIN_MODULE_HPP
