#ifndef RUNTIME_ERROR_HPP
#define RUNTIME_ERROR_HPP

#include <string>

class RuntimeError
{
 private:
  std::string m_message;

 public:
  const std::string&
  message() const
  {
    return m_message;
  }

  RuntimeError(const std::string& message) : m_message{message} {}

  RuntimeError()                    = delete;
  RuntimeError(const RuntimeError&) = delete;
  RuntimeError(RuntimeError&&)      = delete;

  ~RuntimeError() = default;
};

#endif   // RUNTIME_ERROR_HPP
