#include <language/modules/MathFunctionRegisterForVh.hpp>

#include <language/modules/SchemeModule.hpp>
#include <language/utils/BuiltinFunctionEmbedder.hpp>
#include <language/utils/EmbeddedIDiscreteFunctionMathFunctions.hpp>
#include <scheme/IDiscreteFunction.hpp>
#include <scheme/IDiscreteFunctionDescriptor.hpp>

MathFunctionRegisterForVh::MathFunctionRegisterForVh(SchemeModule& scheme_module)
{
  scheme_module._addBuiltinFunction("sqrt",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return sqrt(a); }));

  scheme_module._addBuiltinFunction("abs",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return abs(a); }));

  scheme_module._addBuiltinFunction("sin",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return sin(a); }));

  scheme_module._addBuiltinFunction("cos",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return cos(a); }));

  scheme_module._addBuiltinFunction("tan",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return tan(a); }));

  scheme_module._addBuiltinFunction("asin",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return asin(a); }));

  scheme_module._addBuiltinFunction("acos",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return acos(a); }));

  scheme_module._addBuiltinFunction("atan",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return atan(a); }));

  scheme_module
    ._addBuiltinFunction("atan2",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(std::shared_ptr<const IDiscreteFunction>,
                                                                    std::shared_ptr<const IDiscreteFunction>)>>(
                           [](std::shared_ptr<const IDiscreteFunction> a, std::shared_ptr<const IDiscreteFunction> b)
                             -> std::shared_ptr<const IDiscreteFunction> { return atan2(a, b); }));

  scheme_module
    ._addBuiltinFunction("atan2",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(double, std::shared_ptr<const IDiscreteFunction>)>>(
                           [](double a, std::shared_ptr<const IDiscreteFunction> b)
                             -> std::shared_ptr<const IDiscreteFunction> { return atan2(a, b); }));

  scheme_module
    ._addBuiltinFunction("atan2",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(std::shared_ptr<const IDiscreteFunction>, double)>>(
                           [](std::shared_ptr<const IDiscreteFunction> a,
                              double b) -> std::shared_ptr<const IDiscreteFunction> { return atan2(a, b); }));

  scheme_module._addBuiltinFunction("sinh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return sinh(a); }));

  scheme_module._addBuiltinFunction("cosh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return cosh(a); }));

  scheme_module._addBuiltinFunction("tanh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return tanh(a); }));

  scheme_module._addBuiltinFunction("asinh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return asinh(a); }));

  scheme_module._addBuiltinFunction("acosh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return acosh(a); }));

  scheme_module._addBuiltinFunction("atanh",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return atanh(a); }));

  scheme_module._addBuiltinFunction("exp",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return exp(a); }));

  scheme_module._addBuiltinFunction("log",
                                    std::make_shared<BuiltinFunctionEmbedder<std::shared_ptr<const IDiscreteFunction>(
                                      std::shared_ptr<const IDiscreteFunction>)>>(
                                      [](std::shared_ptr<const IDiscreteFunction> a)
                                        -> std::shared_ptr<const IDiscreteFunction> { return log(a); }));

  scheme_module
    ._addBuiltinFunction("pow",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(double, std::shared_ptr<const IDiscreteFunction>)>>(
                           [](double a, std::shared_ptr<const IDiscreteFunction> b)
                             -> std::shared_ptr<const IDiscreteFunction> { return pow(a, b); }));

  scheme_module
    ._addBuiltinFunction("pow",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(std::shared_ptr<const IDiscreteFunction>, double)>>(
                           [](std::shared_ptr<const IDiscreteFunction> a,
                              double b) -> std::shared_ptr<const IDiscreteFunction> { return pow(a, b); }));

  scheme_module
    ._addBuiltinFunction("pow",
                         std::make_shared<BuiltinFunctionEmbedder<
                           std::shared_ptr<const IDiscreteFunction>(std::shared_ptr<const IDiscreteFunction>,
                                                                    std::shared_ptr<const IDiscreteFunction>)>>(
                           [](std::shared_ptr<const IDiscreteFunction> a, std::shared_ptr<const IDiscreteFunction> b)
                             -> std::shared_ptr<const IDiscreteFunction> { return pow(a, b); }));
}
