#ifndef MESH_NODE_INTERFACE_HPP
#define MESH_NODE_INTERFACE_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/IInterfaceDescriptor.hpp>
#include <mesh/RefItemList.hpp>
#include <utils/Array.hpp>

template <size_t Dimension>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <size_t Dimension>
class [[nodiscard]] MeshNodeInterface   // clazy:exclude=copyable-polymorphic
{
 protected:
  RefNodeList m_ref_node_list;

  std::array<TinyVector<Dimension>, Dimension*(Dimension - 1)> _getBounds(const Mesh<Connectivity<Dimension>>& mesh)
    const;

 public:
  template <size_t MeshDimension>
  friend MeshNodeInterface<MeshDimension> getMeshNodeInterface(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                               const IInterfaceDescriptor& interface_descriptor);

  MeshNodeInterface& operator=(const MeshNodeInterface&) = default;
  MeshNodeInterface& operator=(MeshNodeInterface&&) = default;

  PUGS_INLINE
  const RefNodeList& refNodeList() const
  {
    return m_ref_node_list;
  }

  PUGS_INLINE
  const Array<const NodeId>& nodeList() const
  {
    return m_ref_node_list.list();
  }

 protected:
  MeshNodeInterface(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list);
  MeshNodeInterface(const Mesh<Connectivity<Dimension>>& mesh, const RefEdgeList& ref_edge_list);
  MeshNodeInterface(const Mesh<Connectivity<Dimension>>&, const RefNodeList& ref_node_list);

 public:
  MeshNodeInterface(const MeshNodeInterface&) = default;
  MeshNodeInterface(MeshNodeInterface &&)     = default;

  MeshNodeInterface()          = default;
  virtual ~MeshNodeInterface() = default;
};

template <size_t Dimension>
MeshNodeInterface<Dimension> getMeshNodeInterface(const Mesh<Connectivity<Dimension>>& mesh,
                                                  const IInterfaceDescriptor& interface_descriptor);

#endif   // MESH_NODE_INTERFACE_HPP
