#ifndef MESH_FACE_INTERFACE_HPP
#define MESH_FACE_INTERFACE_HPP

#include <algebra/TinyVector.hpp>
#include <mesh/IInterfaceDescriptor.hpp>
#include <mesh/RefItemList.hpp>
#include <utils/Array.hpp>

template <size_t Dimension>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <size_t Dimension>
class [[nodiscard]] MeshFaceInterface   // clazy:exclude=copyable-polymorphic
{
 protected:
  RefFaceList m_ref_face_list;

 public:
  template <size_t MeshDimension>
  friend MeshFaceInterface<MeshDimension> getMeshFaceInterface(const Mesh<Connectivity<MeshDimension>>& mesh,
                                                               const IInterfaceDescriptor& interface_descriptor);

  MeshFaceInterface& operator=(const MeshFaceInterface&) = default;
  MeshFaceInterface& operator=(MeshFaceInterface&&) = default;

  PUGS_INLINE
  const RefFaceList& refFaceList() const
  {
    return m_ref_face_list;
  }

  PUGS_INLINE
  const Array<const FaceId>& faceList() const
  {
    return m_ref_face_list.list();
  }

 protected:
  MeshFaceInterface(const Mesh<Connectivity<Dimension>>& mesh, const RefFaceList& ref_face_list);

 public:
  MeshFaceInterface(const MeshFaceInterface&) = default;   // LCOV_EXCL_LINE
  MeshFaceInterface(MeshFaceInterface &&)     = default;   // LCOV_EXCL_LINE

  MeshFaceInterface()          = default;
  virtual ~MeshFaceInterface() = default;
};

template <size_t Dimension>
MeshFaceInterface<Dimension> getMeshFaceInterface(const Mesh<Connectivity<Dimension>>& mesh,
                                                  const IInterfaceDescriptor& interface_descriptor);

#endif   // MESH_FACE_INTERFACE_HPP
