#ifndef MESH_DATA_MANAGER_HPP
#define MESH_DATA_MANAGER_HPP

#include <mesh/IMeshData.hpp>
#include <utils/PugsAssert.hpp>
#include <utils/PugsMacros.hpp>

#include <memory>
#include <unordered_map>

class IMesh;

template <size_t>
class Connectivity;

template <typename ConnectivityType>
class Mesh;

template <size_t Dimension>
class MeshData;

class MeshDataManager
{
 private:
  std::unordered_map<const IMesh*, std::shared_ptr<IMeshData>> m_mesh_mesh_data_map;

  static MeshDataManager* m_instance;

  MeshDataManager(const MeshDataManager&) = delete;
  MeshDataManager(MeshDataManager&&)      = delete;

  MeshDataManager()  = default;
  ~MeshDataManager() = default;

 public:
  static void create();
  static void destroy();

  PUGS_INLINE
  static MeshDataManager&
  instance()
  {
    Assert(m_instance != nullptr, "MeshDataManager was not created!");
    return *m_instance;
  }

  void deleteMeshData(const IMesh*);

  template <size_t Dimension>
  MeshData<Dimension>& getMeshData(const Mesh<Connectivity<Dimension>>&);
};

#endif   // MESH_DATA_MANAGER_HPP
