#include <mesh/Dual1DMeshBuilder.hpp>

#include <mesh/Connectivity.hpp>
#include <mesh/DualConnectivityManager.hpp>
#include <mesh/ItemValueUtils.hpp>
#include <mesh/Mesh.hpp>
#include <mesh/MeshData.hpp>
#include <mesh/MeshDataManager.hpp>
#include <mesh/PrimalToDiamondDualConnectivityDataMapper.hpp>
#include <mesh/PrimalToDual1DConnectivityDataMapper.hpp>
#include <utils/Stringify.hpp>

void
Dual1DMeshBuilder::_buildDual1DMeshFrom(const IMesh& i_mesh)
{
  using ConnectivityType = Connectivity<1>;
  using MeshType         = Mesh<Connectivity<1>>;

  const MeshType& primal_mesh = dynamic_cast<const MeshType&>(i_mesh);

  DualConnectivityManager& manager = DualConnectivityManager::instance();

  std::shared_ptr<const ConnectivityType> p_dual_connectivity =
    manager.getDiamondDualConnectivity(primal_mesh.connectivity());

  const ConnectivityType& dual_connectivity = *p_dual_connectivity;

  const NodeValue<const TinyVector<1>> primal_xr = primal_mesh.xr();

  MeshData<1>& primal_mesh_data                  = MeshDataManager::instance().getMeshData(primal_mesh);
  const CellValue<const TinyVector<1>> primal_xj = primal_mesh_data.xj();

  std::shared_ptr primal_to_dual_1d_connectivity_data_mapper =
    manager.getPrimalToDual1DConnectivityDataMapper(primal_mesh.connectivity());

  NodeValue<TinyVector<1>> dual_xr{dual_connectivity};
  primal_to_dual_1d_connectivity_data_mapper->toDualNode(primal_xr, primal_xj, dual_xr);

  m_mesh = std::make_shared<MeshType>(p_dual_connectivity, dual_xr);
}

Dual1DMeshBuilder::Dual1DMeshBuilder(const IMesh& i_mesh)
{
  std::cout << "building Dual1DMesh\n";

  if (i_mesh.dimension() == 1) {
    this->_buildDual1DMeshFrom(i_mesh);
  } else {
    // LCOV_EXCL_START
    throw UnexpectedError("invalid mesh dimension: " + stringify(i_mesh.dimension()));
    // LCOV_EXCL_STOP
  }
}
